%
%   EE6641 Lab2
%
clear all; close all;

Nnums = 10;
useFFT = 1;
filename = 'cellphone.wav';

%% Import the signal
[sig fs] = wavread(filename);
sig = sig(:, 1);
sig = sig(1 : floor(length(sig)/Nnums) * Nnums);

fprintf(['The signal length: ' num2str( length(sig)/fs ) ' sec.\nThe sampling frequency: ' num2str(fs) ' Hz.\n']);

digSigs = reshape( sig, [ length(sig)/Nnums, Nnums ] );

tic;
if ~useFFT
    %% Construct DFT Matrix
    Ndft = size(digSigs, 1);

    
    %%%%%%%%%%%%%%%%%%%% YOUR CODE BELOW %%%%%%%%%%%%%%%%%%%%
    
    DFTMat = zeros( Ndft );
    
    %%%%%%%%%%%%%%%%%%%% YOUR CODE ABOVE %%%%%%%%%%%%%%%%%%%%
    

    
    %% Compute the spectrum of each piece of signal
    spectra = DFTMat * digSigs;
else
    Ndft = size(digSigs, 1);
    spectra = complex( zeros( Ndft, 10 ) );
    for ii = 1:10
        spectra(:, ii) = fft(digSigs(:, ii), Ndft);
    end
end
elapseTimeMillis = toc;

%% Post-processing the spectra
spectra = abs(spectra);
spectra = spectra(1:end/2, :);


%% Visualize the spectra
figure(1);
ff = ( 1:size(spectra, 1) )' / size(spectra, 1) * (fs/2);
for ii = 1:10
    subplot( 10, 1, ii );
    plot( ff, spectra(:, ii) );
    xlim([0 2000]);
end

%% Figuring out what digit has been pressed
BTN_LIST = [
    '1', '2', '3', 'a'; ...
    '4', '5', '6', 'b'; ...
    '7', '8', '9', 'c'; ...
    '.', '0', '#', 'd' 
];
FREQ_LIST_VERT = [ 697, 770, 852, 941 ];
FREQ_LIST_HORIZ = [ 1209, 1336, 1477, 1633 ];



%%%%%%%%%%%%%%%%%%%% YOUR CODE BELOW %%%%%%%%%%%%%%%%%%%%

cellphoneNum = '09xxxxxxxx';

%%%%%%%%%%%%%%%%%%%% YOUR CODE ABOVE %%%%%%%%%%%%%%%%%%%%



%% Print the result
if useFFT, method = 'fft';
else method = 'matrix dft'; end

fprintf( ['The phone number is: ' cellphoneNum '.\n'] );
fprintf( ['The elapsed time of Fourier Transform(' method '): ' num2str(elapseTimeMillis) ' ms.\n'] );

clear BTN_LIST FREQ_LIST_VERT FREQ_LIST_HORIZ ff filename ii method useFFT sig;
