%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% EE6641 HW2                           %
% Time-warping and frequency shifting  %
% based on sinusoidal modeling.m       %
% created by Jeffrey Huang, 11/2015    % 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear; close all;
sw.plot = 0;
% [x,fs] = wavread('wrenpn.wav');
% [x,fs] = wavread('peaches_16.wav');
[x,fs] = wavread('mymom_16.wav');
% [x,fs] = wavread('draw_16.wav');
x = x/max(abs(x)); sound(x,fs);
nx = length(x);

%% ANALYSIS PARAMETERS
frameRate =40;  % frames per second
M = floor(fs/frameRate);  
nFrames = floor(nx/M)*2-1;
R = floor(M/2);  % Exact COLA not required
N = 2^(1+floor(log2(5*M+1))); % FFT length, at least a factor of 5 zero-padding

maxPeaks = input('how many peaks to track? '); 
	% Up to this many sinusoidal peaks (birdsong-specific!)
expandRatio = input('time expansion factor?');
freqShift = input('how many semitones of pitch shift?');
fRatio = 2^(freqShift/12); 

%% VECTOR VARIABLES DECLARATION
amps = zeros(maxPeaks,nFrames);
freqs = zeros(maxPeaks,nFrames);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% ANALYSIS
%%
%w = hanning(M);
w = blackman(M);
df = fs/N;
ff = 0:df:(N-1)*df;
for m=1:nFrames
    %%%%%%%%%%%%%%%%%%%%% YOUR CODE BELOW %%%%%%%%%%%%%%%%%%%%%%
    
    %%%%%%%%%%%%%%%%%%%%% YOUR CODE ABOVE %%%%%%%%%%%%%%%%%%%%%%
end

figure(1)
plot(8000/pi*freqs');
xlabel('frame');
ylabel('hz');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% SYNTHESIS
R = round(R* expandRatio);  % time expansion
freqs = min(pi,freqs*fRatio);
y = zeros((nFrames+1)*R,1);
state = zeros(maxPeaks,3);  % [ampInitials, freqInitials, phaseInitials] 
state(:,1) = ... ;
state(:,2) = .. ;

for m=1:nFrames-1
    %%%%%%%%%%%%%%%%%%%%% YOUR CODE BELOW %%%%%%%%%%%%%%%%%%%%%%
    
    %%%%%%%%%%%%%%%%%%%%% YOUR CODE ABOVE %%%%%%%%%%%%%%%%%%%%%%
end


y = y/(max(abs(y))+1); 
sound(y,fs);
wavwrite(y,fs,'LinearMethod.wav');



