%   EE6641 ASAS Lab3: Spectrogram
%
%       starter.m
%
%   Created by Hao-Wei Lee, 2015.09

clear all; close all;

opt.useFunc = 1; % use built-in spectrogram function or not
opt.windowType = 'hann'; % rectwin, hann, or hamming etc.

D = 0.02;
overlap = 0.8;

if opt.useFunc, spectrogram = str2func('spectrogram');
else spectrogram = str2func('mySpectrogram'); end

window_gen = str2func( opt.windowType );

[sig, fs] = wavread('./test.wav');
win = window_gen( round(D*fs) );

Nfft = power(2, ceil( log2(length(win)) ));
% Nfft = length(win);

S = spectrogram( sig(:, 1), win, round(length(win)*overlap), Nfft );

imshow( abs(S(end:-1:1, :)) );
